<?php
/*
Plugin Name: Scout Keyword research
Plugin URI: https://www.seolab.ir
Description: افزونه پایش کلمات کلیدی اسکاوت
Version: 1.0.0
Author: محسن محمدپور
Author URI: https://www.seolab.ir
License: GPL2
*/

if (!defined('ABSPATH')) exit;

class ScoutPlugin
{

    public function __construct()
    {
        add_action('admin_init', function () {

            if (isset($_POST['scout_login_submit'])) {

                $siteInfo = $this->getSiteInfo();
                $mobile = sanitize_text_field($_POST['mobile']);
                $password = sanitize_text_field($_POST['password']);

                $response = wp_remote_post('https://www.seolab.ir/api/wp/v1/login', [
                    'headers' => ['Content-Type' => 'application/json'],
                    'body' => json_encode([
                        'mobile' => $mobile,
                        'password' => $password,
                        'website' => [
                            'title' => $siteInfo['title'],
                            'domain' => $siteInfo['domain'],
                        ]
                    ])
                ]);

                if (is_wp_error($response)) {
                    echo '<p style="color:red">خطا در ارتباط با سرور</p>';
                } else {
                    $data = json_decode(wp_remote_retrieve_body($response), true);
                    if ($data['success']) {
                        update_option('scout_auth', json_encode($data['data']));
                        wp_redirect(admin_url('admin.php?page=scout-dashboard'));
                        exit;
                        echo '<p style="color:green">ورود موفقیت‌آمیز بود!</p>';
                    } else {
                        echo '<p style="color:red">ورود ناموفق بود!</p>';
                        if (is_array($data['message'])) {
                            echo '<p style="color:red">' . implode('<br>', $data['message']) . '</p>';
                        } else {
                            echo '<p style="color:red">' . $data['message'] . '</p>';
                        }
                    }
                }
            }

            if (isset($_POST['scout_register_submit'])) {
                $siteInfo = $this->getSiteInfo();
                $first_name = sanitize_text_field($_POST['first_name']);
                $last_name = sanitize_text_field($_POST['last_name']);
                $mobile = sanitize_text_field($_POST['mobile']);
                $verify_code = sanitize_text_field($_POST['verify_code']);
                $email = sanitize_email($_POST['email']);
                $password = sanitize_text_field($_POST['password']);

                $response = wp_remote_post('https://www.seolab.ir/api/wp/v1/register', [
                    'headers' => ['Content-Type' => 'application/json'],
                    'body' => json_encode([
                        'first_name' => $first_name,
                        'last_name' => $last_name,
                        'mobile' => $mobile,
                        'verify_code' => $verify_code,
                        'email' => $email,
                        'password' => $password,
                        'website' => [
                            'title' => $siteInfo['title'],
                            'domain' => $siteInfo['domain'],
                        ]
                    ])
                ]);

                if (is_wp_error($response)) {
                    echo '<p style="color:red">خطا در ارتباط با سرور</p>';
                } else {
                    $data = json_decode(wp_remote_retrieve_body($response), true);
                    if (!empty($data['success'])) {
                        update_option('scout_auth', json_encode($data['data']));
                        wp_redirect(admin_url('admin.php?page=scout-dashboard'));
                        exit;
                        echo '<p style="color:green">ثبت نام موفقیت‌آمیز بود!</p>';
                    } else {
                        echo '<p style="color:red">ثبت نام ناموفق بود!</p>';
                        if (is_array($data['message'])) {
                            echo '<p style="color:red">' . implode('<br>', $data['message']) . '</p>';
                        } else {
                            echo '<p style="color:red">' . $data['message'] . '</p>';
                        }
                    }
                }
            }

            if (isset($_POST['scout_signout'])) {
                update_option('scout_auth', null);
                update_option('scout_data', null);
                wp_redirect(admin_url('admin.php?page=scout-dashboard'));
                exit;
            }

            if (isset($_POST['delete_keyword_id'])) {
                $id = intval($_POST['delete_keyword_id']);

                $auth = get_option('scout_auth');
                if ($auth) $auth = json_decode($auth, true);

                if (!empty($auth['access_token']) && !empty($auth['project_id'])) {
                    $response = wp_remote_request(
                        "https://www.seolab.ir/api/wp/v1/keywords/{$id}",
                        [
                            'method'  => 'DELETE',
                            'headers' => [
                                'Authorization' => 'Bearer ' . $auth['access_token'],
                                'Project-ID'    => $auth['project_id'],
                                'Accept'        => 'application/json',
                            ],
                        ]
                    );

                    if (is_wp_error($response)) {
                        echo '<div class="notice notice-error"><p>خطا در حذف کلمه کلیدی.</p></div>';
                    } else {

                        $data = json_decode(wp_remote_retrieve_body($response), true);
                        if ($data['success']) {
                            echo '<div class="notice notice-success"><p>کلمه کلیدی با موفقیت حذف شد.</p></div>';
                        } else {
                            echo '<p style="color:red">حذف ناموفق بود!</p>';
                        }
                    }
                }
            }

            if (isset($_POST['scout_keywords_submit'])) {

                $keywords = $_POST['keywords'];
                $keywords = explode(PHP_EOL, $keywords);

                $data = get_option('scout_auth');
                if ($data) $data = json_decode($data, true);

                $response = wp_remote_post('https://www.seolab.ir/api/wp/v1/keywords', [
                    'headers' => [
                        'Authorization' => 'Bearer ' . $data['access_token'],
                        'Project-ID' => $data['project_id'],
                        'Accept' => 'application/json',
                    ],
                    'body' => [
                        'keywords' => $keywords,
                    ]
                ]);

                if (is_wp_error($response)) {
                    echo '<p style="color:red">خطا در ارتباط با سرور</p>';
                } else {

                    $data = json_decode(wp_remote_retrieve_body($response), true);
                    if ($data['success']) {
                        $this->sync_api(true);
                        wp_redirect(admin_url('admin.php?page=scout-dashboard'));
                        exit;
                        echo '<p style="color:green">کلمات کلیدی با موفقیت ثبت شدند.</p>';
                    } else {
                        echo '<p style="color:red">ثبت ناموفق بود!</p>';
                        if (is_array($data['message'])) {
                            echo '<p style="color:red">' . implode('<br>', $data['message']) . '</p>';
                        } else {
                            echo '<p style="color:red">' . $data['message'] . '</p>';
                        }
                    }
                }
            }

            if (!isset($_GET['page']) || $_GET['page'] !== 'scout-dashboard') {
                return;
            }

            $auth = get_option('scout_auth');
            if ($auth) {
                $auth = json_decode($auth, true);
            }

            $has_auth = !empty($auth['access_token']) && !empty($auth['project_id']);

            if (!$has_auth && !isset($_GET['auth'])) {
                wp_safe_redirect(admin_url('admin.php?page=scout-dashboard&auth=register'));
                exit;
            }

            if ($has_auth && isset($_GET['auth'])) {
                wp_safe_redirect(admin_url('admin.php?page=scout-dashboard'));
                exit;
            }
        });



        add_action('admin_menu', [$this, 'register_admin_pages']);
        add_action('wp_dashboard_setup', [$this, 'add_dashboard_widget']);
        add_action('admin_bar_menu', [$this, 'add_admin_bar_menu'], 100);

        add_filter('cron_schedules', function ($schedules) {
            $schedules['every_thirty_minutes'] = [
                'interval' => 30 * 60,
                'display' => __('Every 30 Minutes')
            ];
            $schedules['every_two_hours'] = [
                'interval' => 2 * 60 * 60,
                'display' => __('Every 2 Hours')
            ];
            return $schedules;
        });
        register_activation_hook(__FILE__, function () {
            if (!wp_next_scheduled('scout_sync_event')) {
                wp_schedule_event(time(), 'every_two_hours', 'scout_sync_event'); // hourly
            }
        });
        register_deactivation_hook(__FILE__, function () {
            wp_clear_scheduled_hook('scout_sync_event');
        });
        add_action('scout_sync_event', function () {
            (new ScoutPlugin())->sync_api(true);
        });
    }

    public function register_admin_pages()
    {
        add_menu_page(
            'پایش کلمات کلیدی اسکاوت',
            'پایش کلمات کلیدی',
            'manage_options',
            'scout-dashboard',
            [$this, 'dashboard_page'],
            'dashicons-welcome-view-site'
        );

        add_submenu_page(
            'scout-dashboard',
            'درباره ما',
            'درباره ما',
            'manage_options',
            'scout-about',
            [$this, 'about_page']
        );
    }

    public function dashboard_page()
    {
        $this->sync_api(true);

        $auth = get_option('scout_auth');
        if ($auth) $auth = json_decode($auth, true);

        $data = get_option('scout_data');
        if ($data) $data = json_decode($data, true);

        $keywords = $data['keywords'] ?? [];
        $widget = $data['widget'] ?? [];

        echo '<div class="wrap"><h1 style="margin-bottom: 12px;">پایش کلمات کلیدی</h1>';

        if (isset($widget['banner']) && !empty($widget['banner'])) {
            $banner = $widget['banner'];
            echo '<a target="_blank" href="' . $banner['url'] . '" style="display: block; margin-bottom: 12px;">';
            echo '<img src="' . $banner['image'] . '" style="display: block;"/>';
            echo '</a>';
        }

        if (isset($auth['access_token']) && !empty($auth['access_token']) && isset($auth['project_id']) && !empty($auth['project_id'])) {

            if (isset($_GET['create']) && $_GET['create'] == true) {
                echo $this->create_keywords_form();
            } else {

                if (count($keywords) > 0) {
                    echo '<div id="scout-widget2" style="margin-top: 24px;">';

                    echo '<div style="display: flex; justify-content: space-between; margin-bottom: 12px;">';
                    echo '<a class="button button-primary" href="'. admin_url('admin.php?page=scout-dashboard&create=true') . '">افزودن کلمات کلیدی</a>';
                    echo '<form method="post">
                <button type="submit" name="scout_signout" class="button">خروج از حساب</button>
            </form>';
                    echo '</div>';

                    echo '<table class="wp-list-table widefat fixed striped table-view-list">';
                    echo '<thead><th>کلمه کلیدی</th><th>رتبه</th><th>صفحه</th><th>تاریخ</th><th></th></thead><tbody>';
                    foreach ($keywords as $keyword) {
                        echo '<tr>';
                        echo '<td>' . $keyword['name'] . '</td>';
                        echo '<td>' . $keyword['rank'] . '</td>';
                        echo '<td><a href="' . $keyword['result_url'] . '">' . $keyword['result_title'] . '</a></td>';
                        echo '<td>' . $keyword['last_processed_at']['fa'] . '</td>';
                        echo '<td>
            <form method="post">
                <input type="hidden" name="delete_keyword_id" value="' . esc_attr($keyword['id']) . '"/>
                <button type="submit" class="button button-small" onclick="return confirm(\'مطمئنید؟\')">حذف</button>
            </form>
          </td>';
                        echo '</tr>';
                    }
                    echo '</tbody></table></div>';
                } else {
                    echo '<h1>هنوز کلمات کلیدی خود را اضافه نکرده اید!</h1>';
                    echo '<a class="button button-primary" href="'. admin_url('admin.php?page=scout-dashboard&create=true') . '">افزودن کلمات کلیدی</a>';
                }
            }
        } else {

            if (isset($_GET['auth'])) {
                if ($_GET['auth'] == 'login') {
                    echo $this->custom_login_form_shortcode();
                }
                if ($_GET['auth'] == 'register') {
                    echo $this->custom_register_form_shortcode();
                }
            }
        }
        echo '</div>';
    }

    public function about_page()
    {
        $data = get_option('scout_data');
        if ($data) $data = json_decode($data, true);

        if (isset($data['about'])) {
            echo $data['about'];
        }
    }

    public function add_dashboard_widget()
    {
        wp_add_dashboard_widget(
            'scout_dashboard_widget',
            'پایش کلمات کلیدی اسکاوت',
            [$this, 'dashboard_widget_content']
        );
    }

    public function dashboard_widget_content()
    {
        $data = get_option('scout_data');
        if ($data) $data = json_decode($data, true);
        $keywords = $data['keywords'] ?? [];
        $widget = $data['widget'] ?? [];

        if (count($keywords) > 0) {
            echo '<div id="scout-widget2">';
            echo '<table class="wp-list-table widefat fixed striped table-view-list pl-table" style="width: calc(100% + 24px); margin: -12px -12px 0 -12px; border: none;">';
            echo '<thead><th>کلمه کلیدی</th><th>رتبه</th><th>تاریخ</th></thead><tbody>';
            foreach ($keywords as $keyword) {
                echo '<tr>';
                echo '<td>' . $keyword['name'] . '</td>';
                echo '<td>' . $keyword['rank'] . '</td>';
                echo '<td>' . $keyword['last_processed_at']['fa'] . '</td>';
                echo '</tr>';
            }
            echo '</tbody></table></div>';
            echo '<div style="text-align: center; margin-top: 24px;"><a href="' . admin_url('admin.php?page=scout-dashboard') . '" class="button button-primary">مدیریت کلمات کلیدی</a></div>';
        } else {
            echo '<div style="text-align: center;">هنوز کلمات کلیدی خود را اضافه نکرده اید!</div>';
            echo '<div style="text-align: center;"><a href="' . admin_url('admin.php?page=scout-dashboard') . '" class="button button-primary">مدیریت کلمات کلیدی</a></div>';
        }

        if (isset($widget['banner']) && !empty($widget['banner'])) {
            $banner = $widget['banner'];
            echo '<a target="_blank" href="' . $banner['url'] . '" style="width: calc(100% + 24px); display: block; margin: 12px -12px -12px -12px;">';
            echo '<img src="' . $banner['image'] . '" style="width: 100%; display: block;"/>';
            echo '</a>';
        }
    }

    public function add_admin_bar_menu($admin_bar)
    {
        $data = get_option('scout_data');
        if ($data) $data = json_decode($data, true);
        if (isset($data['keywords']) && count($data['keywords']) > 0) {

            $admin_bar->add_menu([
                'id' => 'scout-top-menu',
                'title' => 'پایش کلمات کلیدی',
                'href' => false,
                'meta' => ['title' => 'لیست کلمات کلیدی'],
            ]);

            foreach ($data['keywords'] as $i => $keyword) {
                $admin_bar->add_menu([
                    'id' => 'scout-submenu-' . $i,
                    'parent' => 'scout-top-menu',
                    'title' => '<div style="display: flex; justify-content: space-between; gap: 20px;"><span>' . $keyword['name'] . '</span><span>' . $keyword['rank'] . '</span></div>',
                    'href' => admin_url('admin.php?page=scout-dashboard&kw=' . $keyword['name']),
                ]);
            }
        }
    }

    public function sync_api($skip_nonce = false)
    {
        if (!$skip_nonce) {
            check_ajax_referer('scout_nonce', 'nonce');
        }

        $data = get_option('scout_auth');
        if ($data) $data = json_decode($data, true);
        $args = [];
        if (isset($data['access_token']) && !empty($data['access_token']) && isset($data['project_id']) && !empty($data['project_id'])) {

            $args = [
                'headers' => [
                    'Authorization' => 'Bearer ' . $data['access_token'],
                    'Project-ID' => $data['project_id'],
                    'Accept' => 'application/json',
                ]
            ];
        }

        $response = wp_remote_get('https://www.seolab.ir/api/wp/v1/keywords', $args);
        if (is_wp_error($response)) {
            wp_send_json_error(['message' => 'خطا در ارتباط با سرور']);
        }
        $data = json_decode(wp_remote_retrieve_body($response), true);
        if (isset($data['success']) && $data['success']) {
            update_option('scout_data', json_encode($data['data']));
        }
    }

    public function getSiteInfo()
    {
        $siteUrl = home_url();
        $parsed = parse_url($siteUrl);
        $domain = $parsed['scheme'] . '://' . $parsed['host'];
        $site_title = get_bloginfo('name');
        return [
            'domain' => $domain,
            'title' => $site_title,
        ];
    }

    public function create_keywords_form()
    {
        ob_start(); ?>

        <div style="display: flex; justify-content: flex-start; gap: 50px;">
            <form id="custom-login-form" method="post">
                <table class="form-table">
                    <tr>
                        <th>
                            <label>کلمه/کلمات کلیدی:</label>
                        </th>
                        <td>
                            <textarea class="regular-text" rows="10" name="keywords" required></textarea>
                        </td>
                    </tr>
                    <tr>
                        <th></th>
                        <td>
                            <button class="button button-primary" type="submit" name="scout_keywords_submit">ثبت و
                                ذخیره
                            </button>
                        </td>
                    </tr>
                </table>

                <div id="submit-keywords-message"></div>
            </form>
            <div>
                <h3>هر کلمه کلیدی را در یک سطر وارد کنید</h3>
                <p>توجه داشته باشید، برای پایش می توانید حداکثر تا 30 کلمه کلیدی ثبت کنید.</p>
                <h4><a href="<?php echo admin_url('admin.php?page=scout-dashboard'); ?>">بازگشت به لیست پایش کلمات</a>
                </h4>
            </div>
        </div>

        <?php
        return ob_get_clean();
    }

    public function custom_login_form_shortcode()
    {
        $siteInfo = $this->getSiteInfo();
        ob_start(); ?>
        <div style="display: flex; justify-content: flex-start; gap: 50px;">
            <form id="custom-login-form" method="post">
                <table class="form-table">
                    <tr>
                        <th>
                            <label>شماره موبایل:</label>
                        </th>
                        <td>
                            <input type="text" name="mobile" required>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>رمز عبور:</label>
                        </th>
                        <td>
                            <input type="password" name="password" required>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>آدرس وب سایت:</label>
                        </th>
                        <td>
                            <input type="text" readonly disabled value="<?php echo $siteInfo['domain']; ?>">
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <button class="button button-primary" type="submit" name="scout_login_submit">ورود</button>
                        </th>
                    </tr>
                </table>

                <div id="login-message"></div>
            </form>
            <div>
                <h3>جهت استفاده از افزونه باید در اسکاوت وارد شوید.</h3>
                <h4>در صورتی که حساب کاربری ندارید، <a
                            href="<?php echo admin_url('admin.php?page=scout-dashboard&auth=register'); ?>">ثبت نام
                        کنید</a> .</h4>
            </div>
        </div>

        <?php
        return ob_get_clean();
    }

    public function custom_register_form_shortcode()
    {
        $siteInfo = $this->getSiteInfo();
        ob_start(); ?>

        <div style="display: flex; justify-content: flex-start; gap: 50px;">

            <form id="custom-register-form" method="post">
                <table class="form-table">

                    <tr>
                        <th>
                            <label>نام:</label>
                        </th>
                        <td>
                            <input class="regular-text" type="text" name="first_name" required>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>نام خانوادگی:</label>
                        </th>
                        <td>
                            <input class="regular-text" type="text" name="last_name" required>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>شماره موبایل:</label>
                        </th>
                        <td>
                            <input type="text" name="mobile" required>
                            <button class="button button-primary" type="button" id="send-code-btn">ارسال کد تایید
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>کد تایید شماره موبایل:</label>
                        </th>
                        <td>
                            <input type="text" name="verify_code" required>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>ایمیل:</label>
                        </th>
                        <td>
                            <input type="email" name="email">
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>رمز عبور:</label>
                        </th>
                        <td>
                            <input type="password" name="password" required>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label>آدرس وب سایت:</label>
                        </th>
                        <td>
                            <input type="text" readonly disabled value="<?php echo $siteInfo['domain']; ?>">
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <button class="button button-primary" type="submit" name="scout_register_submit">ثبت نام
                            </button>
                        </th>
                    </tr>
                </table>
            </form>

            <div>
                <h3>جهت استفاده از افزونه باید در اسکاوت ثبت نام کنید.</h3>
                <h4>در صورتی که حساب کاربری دارید، <a
                            href="<?php echo admin_url('admin.php?page=scout-dashboard&auth=login'); ?>">وارد شوید</a> .
                </h4>
            </div>
        </div>

        <div id="register-message"></div>

        <script>
            jQuery(document).ready(function ($) {
                $('#send-code-btn').on('click', function () {
                    var mobile = $('input[name="mobile"]').val();
                    if (mobile === "") {
                        alert("لطفاً شماره موبایل را وارد کنید");
                        return;
                    }

                    $.ajax({
                        url: "https://www.seolab.ir/api/wp/v1/verify",
                        type: "POST",
                        data: JSON.stringify({mobile: mobile}),
                        contentType: "application/json",
                        success: function (response) {
                            alert(response['message']);
                        },
                        error: function () {
                            alert("خطا در ارسال کد");
                        }
                    });
                });
            });
        </script>

        <?php
        return ob_get_clean();
    }

}

new ScoutPlugin();
